#!/usr/bin/env python
"""
Window 2 - Otwiera okno na pulpicie, rysuje w nim coś i 
   odczytuje pozycję kursora myszy po kliknięciu
"""

import piface.pfio as pfio      # Biblioteka piface
import os, pygame, sys

pygame.init()                   # Inicjowanie interfejsu graficznego
pfio.init()                     # Inicjowanie biblioteki pfio
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Rysowanie")
screen = pygame.display.set_mode([190,160],0,32)
box = False

def main():
        drawBox(box)
        while True :
            checkForEvent()
            
def drawBox(state):
        boxNum = 0
        # Najpierw rysowany jest prostokąt; jego kolor zależy od sekwencji bitów określających stan
        if state :
                pygame.draw.rect(screen,(255,0,0), (50, 70, 40,40), 0)
        else :
                pygame.draw.rect(screen,(180,180,180), (50, 70, 40,40), 0)
        # Teraz rysowane jest obramowanie pola
        pygame.draw.rect(screen,(0,0,180),(50, 70, 40,40), 3)
        pygame.display.update() # Odświeżanie ekranu
        pfio.write_output(state)
                
def mouseGet() : # Sprawdzanie, gdzie kliknął użytkownik
        global box
        x,y = pygame.mouse.get_pos()
        print "Pozycja kursora w momencie kliknięcia: ",x,y
        if x in range(50,90) and y in range(50,110) :
                box = not box # Zmiana stanu pola
                drawBox(box)        
                
def terminate(): # Zamykanie programu
    print ("Trwa zamykanie - proszę czekać")
    pygame.quit()
    sys.exit()
    
def checkForEvent(): # Sprawdzanie, czy należy zamknąć program i gdzie nastąpiło kliknięcie
    #print "Sprawdzanie, czy należy zamknąć program"
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    elif event.type == pygame.MOUSEBUTTONDOWN :
            mouseGet()
    elif event.type == pygame.KEYDOWN and event.key == pygame.K_ESCAPE :
            terminate()
            
if __name__ == '__main__':
    main()   
